import { useSelector } from "react-redux";

const usePreferences = () => {
    const { allPreferences, loading } =
        useSelector((state) => state.getPreferences) || {};
    const {
        preference,
        company,
        product_inventory,
        product_general,
        verification,
        password,
        address,
    } = allPreferences || {};
    return {
        preference,
        company,
        product_inventory,
        product_general,
        verification,
        password,
        address,
        loading,
    };
};

export default usePreferences;
